CREATE TABLE [dbo].[ACTION_GROUP]
(
[GROUP_ID] [uniqueidentifier] NOT NULL,
[ACTION_ID] [uniqueidentifier] NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_Group_AfterDelete] 
   ON  [dbo].[ACTION_GROUP] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Action_Group_H]
			   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT GROUP_ID, ACTION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_Group_AfterInsert] 
   ON  [dbo].[ACTION_GROUP] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
    	INSERT INTO $(varBMS_HISTORY).[dbo].[Action_Group_H]
			   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT GROUP_ID, ACTION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_Group_AfterUpdate] 
   ON  [dbo].[ACTION_GROUP] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	    INSERT INTO $(varBMS_HISTORY).[dbo].[Action_Group_H]
			   (GROUP_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT GROUP_ID, ACTION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
			

END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Action_Group_InsteadOfInsert] 
   ON  [dbo].[ACTION_GROUP]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @PK INT, @SID VARCHAR(250), @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Action_Group]
			   (GROUP_ID, ACTION_ID, CREATED, CREATEDBY)
			SELECT GROUP_ID, ACTION_ID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;

	ELSE
		INSERT INTO [dbo].[Action_Group]
			   (GROUP_ID, ACTION_ID)
			SELECT GROUP_ID, ACTION_ID
			  FROM inserted;
	
END
GO
ALTER TABLE [dbo].[ACTION_GROUP] ADD CONSTRAINT [PK_ACTION_GROUP] PRIMARY KEY CLUSTERED  ([GROUP_ID], [ACTION_ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ACTION_GROUP] WITH NOCHECK ADD CONSTRAINT [FK_ACTION_GROUP_ACTION] FOREIGN KEY ([ACTION_ID]) REFERENCES [dbo].[ACTION] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[ACTION_GROUP] WITH NOCHECK ADD CONSTRAINT [FK_ACTION_GROUP_ACTION1] FOREIGN KEY ([GROUP_ID]) REFERENCES [dbo].[ACTION] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[ACTION_GROUP] NOCHECK CONSTRAINT [FK_ACTION_GROUP_ACTION]
GO
ALTER TABLE [dbo].[ACTION_GROUP] NOCHECK CONSTRAINT [FK_ACTION_GROUP_ACTION1]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates actions to a group of actions.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of an action that is associated to the group.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'ACTION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the action which is a group of operations.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'GROUP_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP', 'COLUMN', N'UPDATEDBY'
GO
